﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Net.Mail;
using Gemini.Core.WebApplication.Base;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model.Data;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;
using Gemini.Core.JSON.LitJson;
using System.Xml.Xsl;

namespace PI.ZB.N1200.ELearning.WebApplication.API
{
    public partial class ELearning : Gemini.Core.WebApplication.Base.APIComponent
    {
        internal class MethodUserPasswordChange : BaseAPIMethod
        {
            private string _data = null;

            public MethodUserPasswordChange(ELearning Component)
                : base(Component)
            {
            }

            public override string Name
            {
                get { return "userspasswordchange"; }
            }

            protected override bool DoValidate()
            {
                return  (!string.IsNullOrEmpty(_data));
            }

            protected override void DoReadRequestParams()
            {
                _data = Component.APIRequestParams["data"];
            }

            protected override GResponseData DoGetGResponseData()
            {
                if (User != null)
                {
                    try
                    {
                        GUserPasswordChange _GUserPasswordChange = JsonMapper.ToObject<GUserPasswordChange>(_data);

                        BL.Dictionary.GroupType _group = (BL.Dictionary.GroupType)User.GroupEnumID;

                        if (User.Password == _GUserPasswordChange.old_password)
                        {
                            User.Password = _GUserPasswordChange.new_password;

                            Gemini.Core.BL.Base.MethodResult _metodhResult = Component.BLAccount.User.Save(User);

                            if (_metodhResult.Success == true)
                            {
                                StatusCode = StatusCodeType.OK;
                                return new GResponseData();
                            }
                            else
                            {
                                AddErrorMessage(_metodhResult.GetAllText());
                                StatusCode = StatusCodeType.NotAcceptable;
                            }
                        }
                        else
                        {
                            AddErrorMessage("Podano niepoprawne hasło.");
                            StatusCode = StatusCodeType.BadRequest;
                        }


                    }
                    catch
                    {
                        AddErrorMessage("Niepoprawny ciąg danych wejściowych do zapisu ćwiczenia.");
                        StatusCode = StatusCodeType.BadRequest;
                    }                    
                }
                return null;
            }
        }
    }
}
